unit Triangle;
{*******************************************************************************
  ShapesDemo
  Written by David Clegg, davidclegg@optusnet.com.au.

  This unit contains the Triangle class used to render a triangle onto a GDI+
  drawing surface.
*******************************************************************************}

interface

uses
  Shape, System.Drawing, System.Drawing.Drawing2D;

type

  /// <summary>
  /// Class to draw a Triangle.
  /// </summary>
  TTriangle = class(TShape)
  protected
    function GetShape(pStartPoint, pEndPoint: Point): GraphicsPath; override;
  end;

implementation

/// <summary>
/// Create a GraphicsPath object representing the bounds for the triangle
/// </summary>
function TTriangle.GetShape(pStartPoint, pEndPoint: Point): GraphicsPath;
var
  lStartPoint: Point;
  lBottomLeft: Point;
begin
  Result := GraphicsPath.Create;

  lStartPoint := Point.Create(pEndPoint.X - ((pEndPoint.X - pStartPoint.X) div 2), pStartPoint.Y);
  lBottomLeft := Point.Create(pStartPoint.X, pEndPoint.Y);

  Result.AddLine(lStartPoint, pEndPoint);
  Result.AddLine(pEndPoint, lBottomLeft);
  Result.AddLine(lBottomLeft, lStartPoint);
end;

end.
